package gov.va.med.mhv.usermgmt.main.service.converter;

import java.sql.Timestamp;

import org.springframework.core.convert.converter.Converter;

import gov.va.med.mhv.usermgmt.common.dto.DirectMessageDTO;
import gov.va.med.mhv.usermgmt.data.model.DirectMessage;

/**
 * 
 */

/**
 * @author vhaislegberb
 * 
 */
public class DirectMessageConverter implements
		Converter<DirectMessageDTO, DirectMessage> {

	@Override
	public DirectMessage convert(DirectMessageDTO src) {
		DirectMessage dest = new DirectMessage();

		dest.setCreatedDate(src.getCreatedDate() != null ? new Timestamp(src.getCreatedDate().getTime()) : new Timestamp(System.currentTimeMillis()));
		dest.setDirectMessageId(src.getDirectMessageId());
		dest.setDirectMessageStatus(src.getDirectMessageStatus());
		dest.setMessageId(src.getMessageId());
		dest.setModifiedDate(src.getModifiedDate() != null ? new Timestamp(src.getModifiedDate().getTime()) : null);
		dest.setOplock(1);
		dest.setSentToEmailAddress(src.getSentToEmailAddress());
		dest.setUserProfileId(src.getUserProfileId());

		return dest;
	}

}
